<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_Model_Inline extends XenForo_Model
{
	
	public function getUserIps($userId)
	{
		$db = $this->_getDb();
		
		$ips = $db->fetchCol($db->limit(
				'
				SELECT DISTINCT ip
				FROM xf_ip
				WHERE user_id = ?
					AND log_date > ?
				ORDER BY log_date DESC
			', 10
		), array($userId, XenForo_Application::$time - 30 * 86400));
		
		foreach ($ips AS &$ipLog)
		{
			$ipLog = long2ip($ipLog);
		}
		
		return $ips;
	}
	
	public function banUser($userId)
	{
		if ($ban = $this->getModelFromCache('XenForo_Model_Banning')->getBannedUserById($userId))
		{
			$existing = true;
		}
		else
		{
			$existing = false;
		}
		
		return $this->getModelFromCache('XenForo_Model_User')->ban(
				$userId, XenForo_Model_User::PERMANENT_BAN, 'Spam', $existing
		);
	}
	
	public function deleteUser($userId)
	{
		$dw = XenForo_DataWriter::create('XenForo_DataWriter_User');
		$dw->setExistingData($userId);
		return $dw->delete();
	}
	
	public function discourageUser($userId)
	{
		$dw = XenForo_DataWriter::create('XenForo_DataWriter_User');
		$dw->setExistingData($userId);
		$dw->set('is_discouraged', 1);
		return $dw->save();
	}
	
	public function banIPs($ips)
	{
		if (!$ips)
		{
			return false;
		}
		
		foreach ($ips as $ip)
		{
			$this->banIP($ip);
		}
		
		return true;
	}
	
	public function banIP($ip)
	{
		if (!$ip)
		{
			return false;
		}
		
		return $this->getModelFromCache('XenForo_Model_Banning')->banIp($ip);
	}
	
	public function banUserIPs($userId)
	{
		$userIps = $this->getUserIps($userId);
		
		return $this->banIPs($userIps);
	}

	public function discourageIPs($ips)
	{
		if (!$ips)
		{
			return false;
		}
	
		foreach ($ips as $ip)
		{
			$this->discourageIP($ip);
		}
	
		return true;
	}
	
	public function discourageIP($ip)
	{
		if (!$ip)
		{
			return false;
		}
	
		return $this->getModelFromCache('XenForo_Model_Banning')->discourageIp($ip);
	}
	
	public function discourageUserIPs($userId)
	{
		$userIps = $this->getUserIps($userId);
	
		return $this->discourageIPs($userIps);
	}
	
	public function deleteAllUserPosts($userId)
	{
		$posts = $this->getModelFromCache('XenForo_Model_Post')->getPostsByUserInOthersThreads($userId);
		
		$postIds = array_keys($posts);
		
		return $this->deletePosts($postIds);
	}
	
	public function deletePosts($postIds)
	{
		$inlineModPostModel = $this->getModelFromCache('XenForo_Model_InlineMod_Post');
		$inlineModPostModel->enableLogging = true;
		
		return $inlineModPostModel->deletePosts(
				$postIds, array('deleteType' => 'hard', 'skipPermissions' => true, 'reason' => 'Spam Clean')
		);
	}

	public function deleteAllUserThreads($userId, $type, $reason = '')
	{
		$threads = $this->getModelFromCache('XenForo_Model_Thread')->getThreads(array(
				'user_id' => $userId,
				'visible' => true,
				'moderated' => true
		));
		
		$threadIds = array_keys($threads);
		
		return $this->deleteThreads($threadIds, $type, $reason);
	}
	
	public function moveAllUserThreads($userId, $nodeId)
	{
	    $threads = $this->getModelFromCache('XenForo_Model_Thread')->getThreads(array(
	            'user_id' => $userId,
	            'visible' => true,
	            'moderated' => true
	    ));
	    
		foreach ($threads AS $thread)
		{
			$forumIds[] = $thread['node_id'];
		}
		
		$forums = $this->getModelFromCache('XenForo_Model_Forum')->getForumsByIds($forumIds);
		
		foreach ($threads AS $threadId => $thread)
		{
		    if (!isset($forums[$thread['node_id']]))
		    {
		        unset($threads[$threadId]);
		    }
		}
	    
	    foreach ($threads AS $thread)
		{
			$dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread', XenForo_DataWriter::ERROR_SILENT);
			$dw->setExistingData($thread);
			$dw->set('node_id', $nodeId);

			if (array_key_exists($dw->get('node_id'), $forums))
			{
				$dw->setExtraData(XenForo_DataWriter_Discussion_Thread::DATA_FORUM, $forums[$dw->get('node_id')]);
			}

			$dw->save();

			if ($dw->hasChanges())
			{
			    $forum = $forums[$thread['node_id']];
			    $forumTitle = ($forum ? $forum['title'] : '');
			    
				XenForo_Model_Log::logModeratorAction('thread', $thread, 'move', array('from' => $forumTitle));
			}
		}
	}
	
	public function deleteThreads($threadIds, $type, $reason = 'Spam Clean')
	{
		$inlineModThreadModel = $this->getModelFromCache('XenForo_Model_InlineMod_Thread');
		$inlineModThreadModel->enableLogging = true;
		
		return $inlineModThreadModel->deleteThreads(
				$threadIds, array('deleteType' => $type, 'skipPermissions' => true, 'reason' => $reason)
		);
	}
	
	public function deleteProfilePost($profilePosts, $users)
	{
		foreach ($profilePosts AS $profilePost)
		{
			$dw = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_ProfilePost', XenForo_DataWriter::ERROR_SILENT);
			$dw->setExistingData($profilePost);
			if (!$dw->get('profile_post_id'))
			{
				// this may happen if the post was already removed
				continue;
			}
			
			$user = $users[$profilePost['profile_user_id']];
			
			$dw->delete();
			
			XenForo_Model_Log::logModeratorAction(
				'profile_post', $profilePost, 'delete_hard', array('reason' => 'Spam Clean'), $user
			);
		}
	}
	
	public function deleteAllUserProfilePosts($userId)
	{
		$profilePosts = $this->getModelFromCache('XenForo_Model_ProfilePost')->getProfilePostsByUserId($userId);
		
		if (!$profilePosts)
		{
			return false;
		}
		
		$user = $this->getModelFromCache('XenForo_Model_User')->getUserById($userId, array(
				'join' => XenForo_Model_User::FETCH_USER_FULL
		));
		
		foreach ($profilePosts AS $profilePost)
		{
			$dw = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_ProfilePost', XenForo_DataWriter::ERROR_SILENT);
			$dw->setExistingData($profilePost);
			
			if (!$dw->get('profile_post_id'))
			{
				// this may happen if the post was already removed
				continue;
			}
			
			$dw->delete();
			
			XenForo_Model_Log::logModeratorAction(
				'profile_post', $profilePost, 'delete_hard', array('reason' => 'Spam Clean'), $user
			);
		}
		
		return true;
	}
	
	public function logDeleteSpamForUser($userId, $data)
	{
		$userModel = $this->getModelFromCache('XenForo_Model_User');
		
		$user = $userModel->getUserById($userId);
		
		if (!$user)
		{
			return false;
		}
		
		$visitor = XenForo_Visitor::getInstance();
		$db = $this->_getDb();
		
		// log progress
		$db->insert('xf_spam_cleaner_log', array(
				'user_id' => $user['user_id'],
				'username' => $user['username'],
				'applying_user_id' => $visitor['user_id'],
				'applying_username' => $visitor['username'],
				'application_date' => XenForo_Application::$time,
				'data' => serialize(array('user_id' => $userId)+$data)
		));
	}
	
	public function submitUserToSpamDatabase($username, $email, $ip, $services)
	{
		$sshModel = sonnbStopSpamHere_Model_SSH::getInstance();
		$services = array_keys($services);
		
		foreach ($services as $service)
		{
			if (isset($sshModel->services[$service]) && method_exists($sshModel->services[$service], 'add'))
			{
				$sshModel->services[$service]->add(array(
					'email' => $email, 
					'ip' => $ip, 
					'username' => $username
				));
			}
		}
		
		return true;
	}
	
	public function submitUserByUserId($userId, $services)
	{
		$userModel = $this->getModelFromCache('XenForo_Model_User');
		
		$user = $userModel->getUserById($userId);
		
		$userIps = $this->getUserIps($userId);
		
		$lastIp = reset($userIps);
		
		return $this->submitUserToSpamDatabase($user['username'], $user['email'], $lastIp, $services);
	}
}